
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo e($seo_setting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>

    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Our Products')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Our Products')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        PRODUCT PAGE START
    ==============================-->
    <section class="wsus__product_page mt_120 xs_mt_80 mb_120 xs_mb_80">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xxl-6 col-xl-6 col-md-7 col-lg-6">
                    <div class="wsus__product_page_search">
                        <form id="search_form">
                            <input type="text" name="keyword" id="search_keyword" value="<?php echo e(request()->get('keyword')); ?>" placeholder="<?php echo e(__('user.Search your products')); ?>...">
                            <button class="common_btn" type="submit"><i class="far fa-search"></i> <?php echo e(__('user.Search')); ?></button>
                        </form>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-md-5 col-lg-4">
                    <div class="wsus__product_page_search">
                        <select class="select_js" id="sorting">
                            <option value="default" <?php echo e(request()->get('sorting')=='default'? 'selected':''); ?>><?php echo e(__('user.Default sorting')); ?></option>
                            <option value="script" <?php echo e(request()->get('sorting')=='script'? 'selected':''); ?>><?php echo e(__('user.Script product')); ?></option>
                            <option value="image" <?php echo e(request()->get('sorting')=='image'? 'selected':''); ?>><?php echo e(__('user.Image product')); ?></option>
                            <option value="video" <?php echo e(request()->get('sorting')=='video'? 'selected':''); ?>><?php echo e(__('user.Video product')); ?></option>
                            <option value="audio" <?php echo e(request()->get('sorting')=='audio'? 'selected':''); ?>><?php echo e(__('user.Audio product')); ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-8 col-lg-8">
                    <div class="row">
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-xl-6 col-md-6">
                            <div class="wsus__gallery_item">
                                <div class="wsus__gallery_item_img">
                                    <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                                    <ul class="wsus__gallery_item_overlay">
                                        <li><a target="_blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                        <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                                    </ul>
                                </div>
                                <div class="wsus__gallery_item_text">
                                    <p class="price">
                                        <?php if(session()->get('currency_position') == 'right'): ?>
                                            <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                        <?php else: ?>
                                            <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                        <?php endif; ?>
                                    </p>
                                    <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>
                                    <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                            href="javascript:;" onclick="getCatSlug('<?php echo e($product->category->slug); ?>')"><?php echo e($product->category->catlangfrontend->name); ?></a></p>
                                    <ul class="d-flex flex-wrap justify-content-between">
                                        <?php
                                            $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                            $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                                        ?>
                                        <li>
                                            <p>
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <?php if($i <= $review): ?>
                                                    <i class="fas fa-star"></i>
                                                    <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                                            </p>
                                        </li>
                                        <li>
                                            <span class="download"><i class="far fa-download"></i> <?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12 text-center mt-5">
                            <h2 class="text-danger mt-5"><?php echo e(__('user.Product Not Found')); ?></h2>
                       </div>
                        <?php endif; ?>
                    </div>
                    <div class="wsus__pagination mt_50">
                        <div class="row">
                            <?php echo e($products->links('custom_pagination')); ?>

                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4">
                    <div class="wsus__product_sidebar_area mt_25">
                        <div class="wsus__product_sidebar categories">
                            <h3><?php echo e(__('user.Categories')); ?></h3>
                            <ul>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $total_product = App\Models\Product::where(['status' => 1, 'category_id'=>$category->id])->count();
                                ?>
                                <li><a href="javascript:;" onclick="getCatSlug('<?php echo e($category->slug); ?>')"><?php echo e($category->catlangfrontend->name); ?> <span>(<?php echo e($total_product); ?>)</span> </a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="wsus__product_sidebar tags">
                            <h3><?php echo e(__('user.Filter Price')); ?></h3>
                            <div id="slider-range" class="price-filter-range"></div>
                            <div class="range_price_area d-flex">
                                <p><?php echo e(__('user.Price')); ?>: <span><?php echo e(session()->get('currency_icon')); ?></span></p>
                                <div class="range_main_price d-flex">
                                    <input type="text" oninput="validity.valid||(value='0');" id="min_price"
                                        class="price-range-field" readonly />
                                    <input type="text" oninput="validity.valid||(value='1000');" id="max_price"
                                        class="price-range-field" readonly />
                                </div>
                            </div>
                            <input type="hidden" id="filter_min_price" name="min_price" value="0">
                            <input type="hidden" id="filter_max_price" name="max_price" value="1000">
                            <input type="hidden" id="get_min_price" value="<?php echo e($min_price); ?>">
                            <input type="hidden" id="get_max_price" value="<?php echo e($max_price); ?>">
                            <input type="hidden" id="product_max_price" value="<?php echo e($product_max_price); ?>">
                            <input type="hidden" id="session_currency_rate" value="<?php echo e(session()->get('currency_rate')); ?>">
                            <button class="common_btn mt-3 w-100" onclick="priceFilter()"  type="submit"><?php echo e(__('user.Filter')); ?></button>
                        </div>
                    </div>
                    <?php if($ad->status==1): ?>
                    <div class="wsus__product_sidebar_offer">
                        <a target="__blank" href="<?php echo e($ad->link); ?>">
                            <img src="<?php echo e(custom_asset($ad->image)); ?>" alt="offer" class="img-fluid w-100">
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        PRODUCT PAGE END
    ==============================-->

    <form action="<?php echo e(route('products')); ?>" id="productSearchForm">

        <?php if(request()->has('sorting')): ?>
        <input type="hidden" name="sorting" value="<?php echo e(request()->get('sorting')); ?>" id="search_sorting">
        <?php else: ?>
        <input type="hidden" name="sorting" value="" id="search_sorting">
        <?php endif; ?>

        <?php if(request()->has('category')): ?>
            <input type="hidden" name="category" value="<?php echo e(request()->get('category')); ?>" id="search_category_slug">
        <?php else: ?>
            <input type="hidden" name="category" value="" id="search_category_slug">
        <?php endif; ?>


        <?php if(request()->has('min_price')): ?>
        <input type="hidden" name="min_price" value="<?php echo e(request()->get('min_price')); ?>" id="search_min_price">
        <?php else: ?>
            <input type="hidden" name="min_price" value="" id="search_min_price">
        <?php endif; ?>

        <?php if(request()->has('max_price')): ?>
            <input type="hidden" name="max_price" value="<?php echo e(request()->get('max_price')); ?>" id="search_max_price">
        <?php else: ?>
            <input type="hidden" name="max_price" value="" id="search_max_price">
        <?php endif; ?>

        <?php if(request()->has('keyword')): ?>
            <input type="hidden" name="keyword" value="<?php echo e(request()->get('keyword')); ?>" id="keyword">
        <?php else: ?>
            <input type="hidden" name="keyword" value="" id="keyword">
        <?php endif; ?>

    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_js'); ?>
<script>
    (function($) {
        "use strict";
         $(document).ready(function () {

            $("#sorting").on("change", function(){
                $("#search_sorting").val($(this).val());
                $("#productSearchForm").submit();

            });

            $("#search_form").on("submit", function(e){
                e.preventDefault();

                $("#keyword").val($("#search_keyword").val());
                $("#productSearchForm").submit();
            });
        });
    })(jQuery);
    function getCatSlug(slug){
        $("#search_category_slug").val(slug);
        $("#productSearchForm").submit();
    }

    function priceFilter(){
        let filter_min_price = $('#filter_min_price').val();
        let filter_max_price = $('#filter_max_price').val();
        $('#search_min_price').val(filter_min_price);
        $('#search_max_price').val(filter_max_price);
        $("#productSearchForm").submit();
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/product.blade.php ENDPATH**/ ?>