<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('WASABI Setting')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('WASABI Setting')); ?></h1>
            </div>

            <div class="section-body">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.update-wasabi-setting')); ?>" method="POST" >
                                <?php echo csrf_field(); ?>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Wasabi access key')); ?></label>
                                    <input type="text" class="form-control" name="wasabi_access_key" value="<?php echo e($storage_setting->wasabi_access_key ?? ''); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Wasabi secret access key')); ?></label>
                                    <input type="text" class="form-control" name="wasabi_secret_key" value="<?php echo e($storage_setting->wasabi_secret_key ?? ''); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Wasabi region')); ?></label>
                                    <input type="text" class="form-control" name="wasabi_default_region" value="<?php echo e($storage_setting->wasabi_default_region ?? ''); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Wasabi bucket')); ?></label>
                                    <input type="text" class="form-control" name="wasabi_bucket" value="<?php echo e($storage_setting->wasabi_bucket ?? ''); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Wasabi url')); ?></label>
                                    <input type="text" class="form-control" name="wasabi_url" value="<?php echo e($storage_setting->wasabi_url ?? ''); ?>">
                                </div>


                                <div class="form-group">
                                    <div class="control-label"><?php echo e(__('Status')); ?></div>
                                    <label class="mt-2">
                                      <input type="checkbox" name="wasabi_status" class="custom-switch-input" <?php echo e(($storage_setting->wasabi_status ?? '') == 'yes' ? 'checked' : ''); ?>>
                                      <span class="custom-switch-indicator"></span>
                                      <span class="custom-switch-description"><?php echo e(__('Enable/Disable')); ?></span>
                                    </label>
                                  </div>


                                <button class="btn btn-primary" type="submit"><?php echo e(__('Update')); ?></button>



                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\alasmart_laravel\Modules/CustomStorage\Resources/views/wasabi.blade.php ENDPATH**/ ?>