
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo e($seo_setting->seo_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('frontend-content'); ?>
    <?php if($intro_visibility): ?>
    <!--=============================
        BANNER 2 START
    ==============================-->
    <section class="wsus__banner_2" style="background: url(<?php echo e(custom_asset($intro_section->content->home1_bg)); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 col-md-10 m-auto">
                    <div class="wsus__banner_text_2 wow fadeInUp" data-wow-duration="1s">
                        <h1><?php echo e($intro_section->content->sliderlangfrontend->home1_title); ?></h1>
                        <form action="<?php echo e(route('products')); ?>" method="GET">
                            <input type="text" name="keyword" placeholder="<?php echo e(__('user.Search your products')); ?>...">
                            <i class="far fa-search"></i>
                            <button class="common_btn" type="submit"><?php echo e(__('user.Search')); ?></button>
                        </form>
                        <ul class="wsus__banner_counter_2 d-flex flex-wrap justify-content-center mt_40">
                            <li>
                                <span class="counter"><?php echo e($intro_section->content->total_product); ?></span>
                                <span><?php echo e(__('user.k')); ?>+</span>
                                <?php echo e(__('user.Prodcuts')); ?>

                            </li>
                            <li>
                                <span class="counter"><?php echo e($intro_section->content->total_user); ?></span>
                                <span><?php echo e(__('user.k')); ?>+</span>
                                <?php echo e(__('user.Users')); ?>

                            </li>
                            <li>
                                <span class="counter"><?php echo e($intro_section->content->total_sold); ?></span>
                                <span>+</span>
                                <?php echo e(__('user.Million Sells')); ?>

                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BANNER 2 END
    ==============================-->
    <?php endif; ?>

    <?php if($category_visibility): ?>
    <!--=============================
        CATEGORY 2 START
    ==============================-->
    <section class="wsus__categorie_2 pt_115 xs_pt_75">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8 m-auto">
                    <div class="wsus__section_heading mb_50">
                        <h5><?php echo e($category_section->title); ?></h5>
                        <h2><?php echo e($category_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row category_slider_2">
                <?php $__currentLoopData = $category_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3">
                    <div class="wsus__categories_item_2">
                        <div class="icon">
                            <img src="<?php echo e(custom_asset($category->icon)); ?>" alt="category" class="img-fluid w-100">
                        </div>
                        <h3><a href="<?php echo e(route('products', ['category' => $category->slug])); ?>"><?php echo e($category->catlangfrontend->name); ?></a></h3>
                        <?php
                            $product = App\Models\Product::where('category_id', $category->id)->get();
                        ?>
                        <p><?php echo e($product->count()); ?> <?php echo e(__('user.Items')); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        CATEGORY 2 END
    ==============================-->
    <?php endif; ?>

    <?php if($product_section->visibility): ?>
    <!--=============================
        GALLERY START
    ==============================-->
    <section class="wsus__galley mt_120 xs_mt_80 pt_115 xs_pt_75 pb_120 xs_pb_80"
        style="background: url(<?php echo e(asset('frontend/images/gallery_bg2.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8 m-auto">
                    <div class="wsus__section_heading mb_35">
                        <h5><?php echo e($product_section->title); ?></h5>
                        <h2><?php echo e($product_section->description); ?></h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="gallery_filter d-flex flex-wrap mb_5">
                        <button class=" active" data-filter="*"><?php echo e(__('user.All Categories')); ?></button>
                        <?php $__currentLoopData = $product_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button data-filter=".<?php echo e($category->id); ?>"><?php echo e($category->catlangfrontend->name); ?></button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="row grid">
                <?php $__currentLoopData = $product_section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6 <?php echo e($product->category->id); ?>">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="_blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>
                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>
                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>
                            <ul class="d-flex flex-wrap justify-content-between">
                                <?php
                                    $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                    $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                                ?>
                                <li>
                                    <p>
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $review): ?>
                                            <i class="fas fa-star"></i>
                                            <?php else: ?>
                                            <i class="far fa-star"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                                    </p>
                                </li>
                                <li>
                                    <span class="download"><i class="far fa-download"></i> <?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        GALLERY END
    ==============================-->
    <?php endif; ?>


    <!--=============================
        TRENDING THEME START
    ==============================-->
    <?php if($trending_section->visibility): ?>
    <section class="wsus__trending_theme pt_115 xs_pt_75">
        <div class="wsus__trending_theme_bg">
            <img src="<?php echo e(asset('frontend/images/trendy_theme_bg.jpg')); ?>" alt="bg" class="img-fluid w-100">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading heading_left  mb_50">
                        <h5><?php echo e($trending_section->title); ?></h5>
                        <h2><?php echo e($trending_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-8 col-lg-7">
                    <div class="wsus__trending_theme_slider_area">
                        <div class="row trendy_slider">

                            <?php
                                $loop_count = count($trending_section->trending_products) / 4;
                                $latest_index = 0;
                                $is_break = false;
                            ?>

                            <?php for($i = 0; $i<$loop_count; $i++): ?>
                                <?php
                                    $current_index = 1;
                                    $number_of_item = 1;
                                ?>
                                <div class="col-12">
                                    <div class="row">

                                        <?php $__currentLoopData = $trending_section->trending_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending_index => $trending_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($latest_index <= $trending_index): ?>
                                                <?php if($number_of_item <= 4): ?>
                                                    <div class="col-xl-6 col-md-6">
                                                        <div class="wsus__trending_theme_item">
                                                            <div class="wsus__trending_theme_item_img">
                                                                <img src="<?php echo e(custom_asset($trending_product->thumbnail_image)); ?>" alt="img"
                                                                    class="img-fluid w-100">
                                                            </div>
                                                            <div class="wsus__trending_theme_item_text">
                                                                <a class="title" href="<?php echo e(route('product-detail', $trending_product->slug)); ?>"><?php echo e(html_decode($trending_product->productlangfrontend->name)); ?></a>
                                                                <p><span><?php echo e(__('user.By')); ?></span> <?php echo e(html_decode($trending_product->author->name)); ?></p>
                                                                <ul class="d-flex flex-wrap justify-content-between align-items-center">
                                                                    <?php
                                                                        $sale=App\Models\OrderItem::where(['product_id' => $trending_product->id])->get()->count();
                                                                    ?>
                                                                    <li>
                                                                        <span><i class="far fa-download"></i> <?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                                                                    </li>
                                                                    <li><a href="<?php echo e(route('product-detail', $trending_product->slug)); ?>"><i class="far fa-shopping-cart"></i></a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php
                                                        $latest_index = $trending_index;
                                                    ?>
                                                <?php endif; ?>

                                                <?php
                                                    $number_of_item ++;
                                                ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="wsus__trending_theme_single">
                        <div class="wsus__trending_theme_single_img">
                            <img src="<?php echo e(custom_asset($trending_section->trending_offer_image)); ?>" alt="trendy theme" class="img-fluid w-100">
                        </div>
                        <div class="wsus__trending_theme_single_text">
                            <p><?php echo e($trending_section->trending_offer_title1); ?></p>
                            <a class="title" href="<?php echo e($trending_section->trending_offer_link); ?>"><?php echo e($trending_section->trending_offer_title2); ?></a>
                            <a class="common_btn" target="_blank" href="<?php echo e($trending_section->trending_offer_link); ?>"><?php echo e(__('user.Purchase Now')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--=============================
        TRENDING THEME END
    ==============================-->

    <?php if($counter_section->visibitliy): ?>
    <!--=============================
        ABOUT COUNTER START
    ==============================-->
    <section class="wsus__about_counter pt_120 xs_pt_80">
        <div class="container">
            <div class="wsus__about_counter_bg">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home1_icon1)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter1_value); ?></h2>
                            <p><?php echo e($counter_section->counter1_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home1_icon2)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter2_value); ?></h2>
                            <p><?php echo e($counter_section->counter2_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home1_icon3)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter3_value); ?></h2>
                            <p><?php echo e($counter_section->counter3_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home1_icon4)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter4_value); ?></h2>
                            <p><?php echo e($counter_section->counter4_title); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        ABOUT COUNTER END
    ==============================-->
    <?php endif; ?>

    <?php if($featured_section->visibility): ?>
    <!--=============================
        GALLERY 2 START
    ==============================-->
    <section class="wsus__galley_2 pt_115 xs_pt_25">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e($featured_section->title); ?></h5>
                        <h2><?php echo e($featured_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $featured_section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <?php
                                $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                            ?>

                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>

                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>

                            <p class="rating">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                            </p>
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>

                            <div class="like_and_sell">
                                <span class="download"><i class="fas fa-arrow-to-bottom"></i><?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <a href="<?php echo e(route('products', ['featured' => 1])); ?>" class="common_btn"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
        </div>
    </section>
    <!--=============================
        GALLERY 2 END
    ==============================-->
    <?php endif; ?>

    <?php if($template_section->visibility): ?>
    <!--=============================
        TEMPLATE START
    ==============================-->
    <section class="wsus__template mt_120 xs_mt_70 pt_115 xs_pt_80 pb_120 xs_pb_80"
        style="background: url(<?php echo e(asset('frontend/images/template_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8 m-auto">
                    <div class="wsus__section_heading mb_25">
                        <h5><?php echo e($template_section->title); ?></h5>
                        <h2><?php echo e($template_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $template_section->templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-md-6">
                    <div class="wsus__template_item">
                        <div class="icon">
                            <img src="<?php echo e(asset($template->image)); ?>" alt="template" class="img-fluid w-100">
                        </div>
                        <h4><?php echo e($template->templatelangfrontend->title); ?></h4>
                        <p><?php echo e($template->templatelangfrontend->description); ?></p>
                        <a target="__blank" href="<?php echo e($template->link); ?>"><?php echo e(__('user.Learn More')); ?> <i class="far fa-long-arrow-right"></i></a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        TEMPLATE END
    ==============================-->
    <?php endif; ?>


    <?php if($mobile_app->visibility): ?>
    <!--=============================
        DOWNLOAD 2 START
    ==============================-->
    <section class="wsus__download_2 pt_120 xs_pt_80 pb_120 xs_pb_80">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xl-5 col-md-5">
                    <div class="wsus__download_2_img">
                        <img src="<?php echo e(custom_asset($mobile_app->home1_foreground)); ?>" alt="download" class="img-fluid w-100">
                    </div>
                </div>
                <div class="col-xl-6 col-md-7">
                    <div class="wsus__download_2_text">
                        <h2><?php echo strip_tags(clean($mobile_app->title1),'<span>'); ?></h2>
                        <p><?php echo e($mobile_app->description); ?></p>
                        <ul class="d-flex flex-wrap">
                            <li>
                                <a target="__blank" href="<?php echo e($mobile_app->play_store_link); ?>">
                                    <img src="<?php echo e(asset('frontend/images/download_icon_3.jpg')); ?>" alt="download" class="img-fluid w-100">
                                </a>
                            </li>
                            <li>
                                <a target="__blank" href="<?php echo e($mobile_app->apple_store_link); ?>">
                                    <img src="<?php echo e(asset('frontend/images/download_icon_4.jpg')); ?>" alt="download" class="img-fluid w-100">
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        DOWNLOAD 2 END
    ==============================-->
    <?php endif; ?>


    <?php if($partner_section->visibility): ?>
    <!--=============================
        CUSTOMER START
    ==============================-->
    <section class="wsus__customer pt_115 xs_pt_75 mb_120 xs_mb_80" style="background: url(<?php echo e(asset('frontend/images/customer_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8 m-auto">
                    <div class="wsus__section_heading mb_25">
                        <h5><?php echo e($partner_section->title); ?></h5>
                        <h2><?php echo e($partner_section->description); ?></h2>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                <?php $__currentLoopData = $partner_section->partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-2 col-sm-6 col-lg-3">
                    <div class="wsus__customer_logo">
                        <a href="<?php echo e($partner->link); ?>" target="__blank">
                            <img src="<?php echo e(custom_asset($partner->logo)); ?>" alt="brand" class="img-fluid w-100">
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="wsus__go_offer" style="background: url(https://i.ibb.co/pWN05Bf/subs-bg.jpg);">
                        <p><?php echo strip_tags(clean($partner_section->offer_title1),'<span>'); ?></p>
                        <span class="support">Lifetime update and 6 months support.</span>
                        <a class="common_btn" href="<?php echo e($partner_section->offer_link); ?>" target="__blank"><?php echo e(__('user.Go to Offer page')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        CUSTOMER END
    ==============================-->
    <?php endif; ?>


    <?php if($home1_blog_section->visibility): ?>
    <!--=============================
        BLOG START
    ==============================-->
    <section class="wsus__blog pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="wsus__section_heading mb_20">
                        <h5><?php echo e($home1_blog_section->title); ?></h5>
                        <h2><?php echo e($home1_blog_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $home1_blog_section->blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__blog_3">
                        <div class="wsus__blog_3_img">
                            <img src="<?php echo e(custom_asset($blog->image)); ?>" alt="blog" class="img-fluid w-100">
                        </div>
                        <div class="wsus__blog_3_text">
                            <a class="categori" href="javascript:;"><?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d M')); ?></a>
                            <a class="title" href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->bloglanguagefrontend->title); ?></a>
                            <p class="description"><?php echo e($blog->bloglanguagefrontend->short_description); ?></p>
                            <ul>
                                <li>
                                    <div class="img">
                                        <img src="<?php echo e(custom_asset($blog->admin->image)); ?>" alt="author" class="img-fluid w-100">
                                    </div>
                                    <p><span><?php echo e(__('user.By')); ?></span> <?php echo e($blog->admin->name); ?> </p>
                                </li>

                                <li><a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e(__('user.Read More')); ?></a></li>

                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        BLOG END
    ==============================-->
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\alasmart_cc\main_files\main_files\resources\views/index.blade.php ENDPATH**/ ?>